# Changelog

All notable changes to this project will be documented in this file. See [standard-version](https://github.com/conventional-changelog/standard-version) for commit guidelines.

### [2.0.6](https://github.com/zillow/react-slider/compare/v2.0.5...v2.0.6) (2023-06-27)

### [2.0.5](https://github.com/zillow/react-slider/compare/v2.0.4...v2.0.5) (2023-06-03)


### Bug Fixes

* prevent snap back issue on mobile ([107e2bb](https://github.com/zillow/react-slider/commit/107e2bbd83fb5823ea803714d6c2262ec28f41ae))


### Code Refactoring

* avoid manipulating state directly ([6ca5853](https://github.com/zillow/react-slider/commit/6ca5853341022cfc85e0e114ad893582f29dfb97))


### Continuous Integration

* inverted sliders, add simple tests ([9c50f38](https://github.com/zillow/react-slider/commit/9c50f389cc6da91c5eaae78ed61193893a5ad500))
* inverted sliders, cleanup ([bb0ed77](https://github.com/zillow/react-slider/commit/bb0ed7727ebf80b823b7df7a66ecbe2f28f31898))
* inverted sliders, honor inverted key down handler for horizontal sliders ([bdb2292](https://github.com/zillow/react-slider/commit/bdb22927cf755deff5cfd43f4375caa90a1e8e68))


### Tests

* update snapshot ([4ead745](https://github.com/zillow/react-slider/commit/4ead74593ba68dc4fcaaed01139a4c9466dcb48f))

### [2.0.4](https://github.com/zillow/react-slider/compare/v2.0.3...v2.0.4) (2022-09-12)


### Bug Fixes

* module resolution ([2fbdec6](https://github.com/zillow/react-slider/commit/2fbdec621205105c59174df48e9e5b0298b062ca))
* Set empty style porperty values to undefined instead of empty string ([9456005](https://github.com/zillow/react-slider/commit/9456005bd258518b74a14e58010b385532ace64d)), closes [#271](https://github.com/zillow/react-slider/issues/271)

### [2.0.3](https://github.com/zillow/react-slider/compare/v2.0.2...v2.0.3) (2022-08-18)

### [2.0.2](https://github.com/zillow/react-slider/compare/v2.0.1...v2.0.2) (2022-08-18)


### Bug Fixes

* dual package extensions ([ef1cb1e](https://github.com/zillow/react-slider/commit/ef1cb1e8ac130362366dc9cbeb1bc96ac7b9cd3b))

### [2.0.1](https://github.com/zillow/react-slider/compare/v2.0.0...v2.0.1) (2022-05-16)

## [2.0.0](https://github.com/zillow/react-slider/compare/v1.3.1...v2.0.0) (2022-03-29)


### ⚠ BREAKING CHANGES

* update `create-react-styleguide` to 8x

### Features

* add ResizeObserver to handle slider resize programatically ([95bd172](https://github.com/zillow/react-slider/commit/95bd1720f79896ebf3d78a66af1f31ebb9fc58af))
* provide root export ([7b0c97d](https://github.com/zillow/react-slider/commit/7b0c97d4ab8be21f66c66ae7dbd08f7d9fa5805c))
* upgrade husky and add conventional commit ([caf8246](https://github.com/zillow/react-slider/commit/caf824641eb03e8dd19a1ae09dc4e72f30d928e7))


### Build System

* update `create-react-styleguide` to 8x ([d1cbe4e](https://github.com/zillow/react-slider/commit/d1cbe4ec3930e8eb06c0e23da8558d5c1d178c35))

### [1.3.1](https://github.com/zillow/react-slider/compare/v1.3.0...v1.3.1) (2021-06-14)


### Bug Fixes

* ignore meta key events in keyDown handler ([cde4c80](https://github.com/zillow/react-slider/commit/cde4c8069bb95cd0a70e52693df533787658b418))

## [1.3.0](https://github.com/zillow/react-slider/compare/v1.2.0...v1.3.0) (2021-06-03)


### Features

* add thumb index to on change events ([f0c9684](https://github.com/zillow/react-slider/commit/f0c9684da65ba0c0dd0774f9f978a644aa436280)), closes [#212](https://github.com/zillow/react-slider/issues/212)

## [1.2.0](https://github.com/zillow/react-slider/compare/v1.1.4...v1.2.0) (2021-05-18)


### Features

* Add support for multiple values in ariaLabelledby ([28eb332](https://github.com/zillow/react-slider/commit/28eb332decafa692cb4c0a8f44e2a57198638087))
* Adding a new ariaLabelledby prop for use with Assistive Technologies ([7d8cc4d](https://github.com/zillow/react-slider/commit/7d8cc4d1ea7fa06c6beaa38b1f9f833a38b2c9a6))


### Documentation

* Adding separate arialabelledby examples ([5c97326](https://github.com/zillow/react-slider/commit/5c973268051f329024ade9f9f398931f341aead4))
* Removing ariaLabel from ariaLabelledBy examples and htmlFor declarations ([5fbc3de](https://github.com/zillow/react-slider/commit/5fbc3deb8e270273105ca39ec036c383a3c76933))

### [1.1.4](https://github.com/zillow/react-slider/compare/v1.1.3...v1.1.4) (2021-01-22)


### Bug Fixes

* set position absolute for marks at render ([7d979e7](https://github.com/zillow/react-slider/commit/7d979e7f9e43b8ba94bebc82ac0081d111efecbd)), closes [#203](https://github.com/zillow/react-slider/issues/203)

### [1.1.3](https://github.com/zillow/react-slider/compare/v1.1.2...v1.1.3) (2021-01-21)

### [1.1.2](https://github.com/zillow/react-slider/compare/v1.1.1...v1.1.2) (2020-11-10)


### Bug Fixes

* `onAfterChange` now returns the correct value when used as a controlled component ([03fcc17](https://github.com/zillow/react-slider/commit/03fcc175df5ee28644e122e87592991d9467f765)), closes [#201](https://github.com/zillow/react-slider/issues/201)

### [1.1.1](https://github.com/zillow/react-slider/compare/v1.1.0...v1.1.1) (2020-11-03)


### Bug Fixes

* onChange now returns the correct value when used as a controlled component ([b0aef7f](https://github.com/zillow/react-slider/commit/b0aef7f8a40b0d8dbc1ec31fd3c35e87acd10bbd)), closes [#197](https://github.com/zillow/react-slider/issues/197)


### Code Refactoring

* UNSAFE_componentWillReceiveProps replaced in favor of getDerivedStateFromProps ([5fff681](https://github.com/zillow/react-slider/commit/5fff681b4bfca7893db246c25d6979aa3362ac9f)), closes [#193](https://github.com/zillow/react-slider/issues/193)

## [1.1.0](https://github.com/zillow/react-slider/compare/v1.0.11...v1.1.0) (2020-11-03)


### Features

* add step support for marks ([38f29d3](https://github.com/zillow/react-slider/commit/38f29d30c3fd5ba6dc1f4d1a3fc6edca12770b35))
* add support for boolean marks and mark class ([85060d2](https://github.com/zillow/react-slider/commit/85060d2de5cfa0c9f7ad385eefa682936b4bbc09))
* add support for marks ([0d1a878](https://github.com/zillow/react-slider/commit/0d1a8784b611c58ed366b3b2d0271b6c3f712175))
* add support to custom marks ([21da836](https://github.com/zillow/react-slider/commit/21da836379627ac25df469bfc6716154f47d9826))


### Documentation

* update examples with marks ([ecffc59](https://github.com/zillow/react-slider/commit/ecffc5954d625bbea54036413618e8bdc2b7b256))

### [1.0.11](https://github.com/zillow/react-slider/compare/v1.0.10...v1.0.11) (2020-09-22)


### Bug Fixes

* Revert "refactor: UNSAFE_componentWillReceiveProps replaced in favor of getDerivedStateFromProps" to fix controlled components ([d068026](https://github.com/zillow/react-slider/commit/d068026ad1e0b723a5c76a819f927cdf20107f55)), closes [#197](https://github.com/zillow/react-slider/issues/197)

### [1.0.10](https://github.com/zillow/react-slider/compare/v1.0.9...v1.0.10) (2020-09-21)


### Build System

* update create-react-styleguide@^6 ([222ea5f](https://github.com/zillow/react-slider/commit/222ea5f53500d3319b2eed401e2e50ffc432b4ab))
* update standard-version and add a versionrc to include more config types during releases ([5deae9a](https://github.com/zillow/react-slider/commit/5deae9a8b5cd9f6f304597fca96117c81e86fdc1))


### Code Refactoring

* UNSAFE_componentWillReceiveProps replaced in favor of getDerivedStateFromProps ([904e927](https://github.com/zillow/react-slider/commit/904e927bba111820f87726ee09f4890fc4004ba9)), closes [#193](https://github.com/zillow/react-slider/issues/193)

## [1.0.9](https://github.com/zillow/react-slider/compare/v1.0.8...v1.0.9) (2020-09-08)



## [1.0.8](https://github.com/zillow/react-slider/compare/v1.0.7...v1.0.8) (2020-06-15)


### Bug Fixes

* account for floating point operations when stepping values with the keyboard ([93f89d8](https://github.com/zillow/react-slider/commit/93f89d811f639837d7ba81a48524224cd672c2aa)), closes [#179](https://github.com/zillow/react-slider/issues/179)
* call `onBeforeChange` and `onAfterChange` lifecycle methods when clicking track ([1e3d90e](https://github.com/zillow/react-slider/commit/1e3d90e13203cc860ed8b52651008956af197a71)), closes [#180](https://github.com/zillow/react-slider/issues/180)
* encapsulate value reference within ReactSlider ([#181](https://github.com/zillow/react-slider/issues/181)) ([453855f](https://github.com/zillow/react-slider/commit/453855f24b210be7ae5a889a3ca6b6f7925b2194))



## [1.0.7](https://github.com/zillow/react-slider/compare/v1.0.6...v1.0.7) (2020-05-17)


### Bug Fixes

* make sure resize is called after the DOM is ready when re-rendering ([46f616e](https://github.com/zillow/react-slider/commit/46f616e1ed71f60611c377015fceaea2bf52a3ca)), closes [#136](https://github.com/zillow/react-slider/issues/136)



## [1.0.6](https://github.com/zillow/react-slider/compare/v1.0.5...v1.0.6) (2020-05-10)


### Bug Fixes

* prevent vertical scroll on thumb touch ([#171](https://github.com/zillow/react-slider/issues/171)) ([2f6dda3](https://github.com/zillow/react-slider/commit/2f6dda360eb814efc5e491ca8db62ac03719255a))



## [1.0.5](https://github.com/zillow/react-slider/compare/v1.0.4...v1.0.5) (2020-05-09)



## [1.0.4](https://github.com/zillow/react-slider/compare/v1.0.3...v1.0.4) (2020-04-24)


### Bug Fixes

* update offset calculation to support IE >=9 ([78718d1](https://github.com/zillow/react-slider/commit/78718d179209684a11863f8d7ff674c759f72966))



## [1.0.3](https://github.com/zillow/react-slider/compare/v1.0.2...v1.0.3) (2020-02-14)


### Bug Fixes

* change event handlers are now more reliable ([f1282d4](https://github.com/zillow/react-slider/commit/f1282d442d9d8ede3dca6c6ca91174b79461b61f)), closes [#161](https://github.com/zillow/react-slider/issues/161)
* no need to pause touch events as they do not cause text selection ([8e3e275](https://github.com/zillow/react-slider/commit/8e3e27526a8e48689fe72a88ed5f70e554bf375c)), closes [#162](https://github.com/zillow/react-slider/issues/162)



## [1.0.2](https://github.com/zillow/react-slider/compare/v1.0.1...v1.0.2) (2020-01-11)


### Bug Fixes

* clicking on the track of a vertical slider should move the correct handle ([114a56d](https://github.com/zillow/react-slider/commit/114a56d)), closes [#156](https://github.com/zillow/react-slider/issues/156)
* make sure borders are accounted for when calculating the slider size ([9e6f2f4](https://github.com/zillow/react-slider/commit/9e6f2f4)), closes [#152](https://github.com/zillow/react-slider/issues/152)



## [1.0.1](https://github.com/zillow/react-slider/compare/v1.0.0...v1.0.1) (2019-10-22)


### Bug Fixes

* mark componentWillReceiveProps as UNSAFE ([c6e8439](https://github.com/zillow/react-slider/commit/c6e8439)), closes [#149](https://github.com/zillow/react-slider/issues/149)



# [1.0.0](https://github.com/zillow/react-slider/compare/v0.11.2...v1.0.0) (2019-09-27)


### Bug Fixes

* `onAfterChange` was not being fired ([71746b2](https://github.com/zillow/react-slider/commit/71746b2)), closes [#3](https://github.com/zillow/react-slider/issues/3)
* add IE11 arrow key support ([20afb9e](https://github.com/zillow/react-slider/commit/20afb9e))
* aria keyboard support corrected so that left and down decreases and right and up increases ([1739606](https://github.com/zillow/react-slider/commit/1739606)), closes [#144](https://github.com/zillow/react-slider/issues/144)
* do nothing when right clicking on the slider ([9fa9eb4](https://github.com/zillow/react-slider/commit/9fa9eb4))
* Home and End keys no longer scroll the page when setting the value ([e8c8e1f](https://github.com/zillow/react-slider/commit/e8c8e1f))
* remove active state on thumb on blur ([f05c7b1](https://github.com/zillow/react-slider/commit/f05c7b1))
* the active thumb should get focus when a value is selected ([f1cc0cc](https://github.com/zillow/react-slider/commit/f1cc0cc))


### Code Refactoring

* remove support for custom thumbs via `children` ([3cb3413](https://github.com/zillow/react-slider/commit/3cb3413))


### Features

* "handle" and "bar" are now "thumb" and "track" to follow `input[type=range]` nomenclature ([e4e8ff8](https://github.com/zillow/react-slider/commit/e4e8ff8))
* `ariaValuetext` now supports a function for dynamic value text ([021a547](https://github.com/zillow/react-slider/commit/021a547))
* `renderThumb` now renders the entire thumb node rather than just the thumb content ([669dcdb](https://github.com/zillow/react-slider/commit/669dcdb))
* `withTracks` is now true by default ([a450420](https://github.com/zillow/react-slider/commit/a450420))
* add `renderBar` render prop for customizing bar content ([0de9013](https://github.com/zillow/react-slider/commit/0de9013))
* add `renderHandle` render prop for dynamic handle content ([c87ed4b](https://github.com/zillow/react-slider/commit/c87ed4b))
* add `valueNow` to state objects of `ariaValuetext` and `renderThumb` for easier access to the current value ([94712f2](https://github.com/zillow/react-slider/commit/94712f2))
* add aria-orientation to slider ([5125a98](https://github.com/zillow/react-slider/commit/5125a98))
* add support for Page Up and Page Down keys ([ed67408](https://github.com/zillow/react-slider/commit/ed67408))
* pass `value` state to render props ([8b0615d](https://github.com/zillow/react-slider/commit/8b0615d))
* remove dependency on create-react-class ([648512e](https://github.com/zillow/react-slider/commit/648512e))
* the paging value is now configurable via the `pageFn` prop ([de75419](https://github.com/zillow/react-slider/commit/de75419))


### BREAKING CHANGES

* The render props `renderThumb` and `renderTrack` are now passed two arguments
instead of one, `props` and `state`. This makes it easier to just spread props when using
a render function.
* `renderThumb` was previously given the indexed handle value
which now needs to be derived from `value` and `index.
* custom thumbs via `children` is no longer supported.
To customize thumbs, use the `renderThumb` render prop instead.
* `withTracks` is more commonly true than false,
so we are making that the default
* "handle" and "bar" props have been renamed to "thumb" and "track",
e.g. `withBars` is now `withTracks`, and `handleClassName` is now `thumbClassName`
