"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = require("react");

var _utils = require("../utils");

var _patterns = require("../patterns");

var _default = [{
  key: 'youtube',
  name: 'YouTube',
  canPlay: _patterns.canPlay.youtube,
  lazyPlayer: /*#__PURE__*/(0, _react.lazy)(function () {
    return import(
    /* webpackChunkName: 'reactPlayerYouTube' */
    './YouTube');
  })
}, {
  key: 'soundcloud',
  name: 'SoundCloud',
  canPlay: _patterns.canPlay.soundcloud,
  lazyPlayer: /*#__PURE__*/(0, _react.lazy)(function () {
    return import(
    /* webpackChunkName: 'reactPlayerSoundCloud' */
    './SoundCloud');
  })
}, {
  key: 'vimeo',
  name: 'Vimeo',
  canPlay: _patterns.canPlay.vimeo,
  lazyPlayer: /*#__PURE__*/(0, _react.lazy)(function () {
    return import(
    /* webpackChunkName: 'reactPlayerVimeo' */
    './Vimeo');
  })
}, {
  key: 'facebook',
  name: 'Facebook',
  canPlay: _patterns.canPlay.facebook,
  lazyPlayer: /*#__PURE__*/(0, _react.lazy)(function () {
    return import(
    /* webpackChunkName: 'reactPlayerFacebook' */
    './Facebook');
  })
}, {
  key: 'streamable',
  name: 'Streamable',
  canPlay: _patterns.canPlay.streamable,
  lazyPlayer: /*#__PURE__*/(0, _react.lazy)(function () {
    return import(
    /* webpackChunkName: 'reactPlayerStreamable' */
    './Streamable');
  })
}, {
  key: 'wistia',
  name: 'Wistia',
  canPlay: _patterns.canPlay.wistia,
  lazyPlayer: /*#__PURE__*/(0, _react.lazy)(function () {
    return import(
    /* webpackChunkName: 'reactPlayerWistia' */
    './Wistia');
  })
}, {
  key: 'twitch',
  name: 'Twitch',
  canPlay: _patterns.canPlay.twitch,
  lazyPlayer: /*#__PURE__*/(0, _react.lazy)(function () {
    return import(
    /* webpackChunkName: 'reactPlayerTwitch' */
    './Twitch');
  })
}, {
  key: 'dailymotion',
  name: 'DailyMotion',
  canPlay: _patterns.canPlay.dailymotion,
  lazyPlayer: /*#__PURE__*/(0, _react.lazy)(function () {
    return import(
    /* webpackChunkName: 'reactPlayerDailyMotion' */
    './DailyMotion');
  })
}, {
  key: 'mixcloud',
  name: 'Mixcloud',
  canPlay: _patterns.canPlay.mixcloud,
  lazyPlayer: /*#__PURE__*/(0, _react.lazy)(function () {
    return import(
    /* webpackChunkName: 'reactPlayerMixcloud' */
    './Mixcloud');
  })
}, {
  key: 'vidyard',
  name: 'Vidyard',
  canPlay: _patterns.canPlay.vidyard,
  lazyPlayer: /*#__PURE__*/(0, _react.lazy)(function () {
    return import(
    /* webpackChunkName: 'reactPlayerVidyard' */
    './Vidyard');
  })
}, {
  key: 'kaltura',
  name: 'Kaltura',
  canPlay: _patterns.canPlay.kaltura,
  lazyPlayer: /*#__PURE__*/(0, _react.lazy)(function () {
    return import(
    /* webpackChunkName: 'reactPlayerKaltura' */
    './Kaltura');
  })
}, {
  key: 'file',
  name: 'FilePlayer',
  canPlay: _patterns.canPlay.file,
  canEnablePIP: function canEnablePIP(url) {
    return _patterns.canPlay.file(url) && (document.pictureInPictureEnabled || (0, _utils.supportsWebKitPresentationMode)()) && !_patterns.AUDIO_EXTENSIONS.test(url);
  },
  lazyPlayer: /*#__PURE__*/(0, _react.lazy)(function () {
    return import(
    /* webpackChunkName: 'reactPlayerFilePlayer' */
    './FilePlayer');
  })
}];
exports["default"] = _default;